package fr.asip.cps3.exemple.vues.menus;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionListener;

import javax.swing.JCheckBoxMenuItem;

/**
 * Classe modlisant un item de menu
 *
 */
public class ItemMenuCheckbox extends JCheckBoxMenuItem {

	private static final long serialVersionUID = -7526600025198078513L;

	/**
	 * Identifiant du menu parent
	 */
	private String idParent;
	
	/**
	 * Identifiant de l'item de menu 
	 */
	private String id;
	
	/**
	 * Dtermine si l'item doit tre affich ou non (dans le cas du verrouillage des menus)
	 */
	private boolean actif;
	
	/**
	 * Ecouteur positionn sur l'item de menu
	 */
	private ActionListener actionEcouteur = null;
	
	/**
	 * Constructeur  5 arguments
	 * @param id Identifiant de l'item de menu
	 * @param idParent Identifiant du menu parent
	 * @param label Libell de l'item de menu
	 * @param enable Boolen attestant du caractre actionnable de l'item de menu
	 * @param visible Boolen attestant du caractre visible de l'item de menu
	 */
	public ItemMenuCheckbox(String id, String idParent, String label, boolean enable, boolean visible) {
		super(label);
		this.idParent=idParent;
		this.id=id;
		setVisible(visible);
		setEnabled(enable);
		actif=enable;
		setBackground(Color.WHITE);
	}

	/**
	 * Constructeur  6 arguments
	 * @param id Identifiant de l'item de menu
	 * @param idParent Identifiant du menu parent
	 * @param label Libell de l'item de menu
	 * @param enable Boolen attestant du caractre actionnable de l'item de menu
	 * @param visible Boolen attestant du caractre visible de l'item de menu
	 * @param ecouteur Ecouteur positionn sur l'item de menu
	 */
	public ItemMenuCheckbox(String id, String idParent, String label, boolean enable, boolean visible,ActionListener ecouteur) {
		this(id,idParent,label,enable,visible);
		setEcouteur(ecouteur);
	}	

	/**
	 * Constructeur  7 arguments
	 * @param id Identifiant de l'item de menu
	 * @param idParent Identifiant du menu parent
	 * @param label Libell de l'item de menu
	 * @param bold Boolen de mise en forme "gras" de l'item de menu
	 * @param enable Boolen attestant du caractre actionnable de l'item de menu
	 * @param visible Boolen attestant du caractre visible de l'item de menu
	 * @param ecouteur Ecouteur positionn sur l'item de menu
	 */
	public ItemMenuCheckbox(String id, String idParent, String label, boolean bold, boolean enable, boolean visible,ActionListener ecouteur) {
		this(id,idParent,label,enable,visible,ecouteur);
		if(bold)
			setFont(new Font("Sans-Serif", Font.BOLD, 11));
		
	}

	/**
	 * Accesseur 
	 * @return L'identifiant du menu parent
	 */
	public String getIdParent() {
		return idParent;
	}

	/**
	 * Accesseur 
	 * @return L'identifiant de l'item de menu
	 */
	public String getId() {
		return id;
	}
	
	/**
	 * Mutateur
	 * @param L'identifiant de l'item de menu
	 */
	protected void setId(String id) {
		this.id=id;
	}

	/**
	 * Accesseur
	 * @return L'couteur positionn sur l'item de menu
	 */
	public ActionListener getActionEcouteur() {
		return actionEcouteur;
	}	
	
	/**
	 * Mutateur
	 * @param L'couteur Ecouteur positionn sur l'item de menu
	 */
	public void setEcouteur(ActionListener ecouteur){
		
		if(!isEcouteur()) {
			this.addActionListener(ecouteur);
			actionEcouteur=ecouteur;
		}
		
	}

	/**
	 * Retourne un boolen attestant du positionnement d'un couteur sur l'item de menu
	 * @return Boolen attestant du positionnement d'un couteur sur l'item de menu
	 */
	public boolean isEcouteur(){
		return actionEcouteur!=null;
	}

	/**
	 * Acceseur
	 * Dtermine si l'item doit tre affich ou non (dans le cas du verrouillage des menus)
	 * @return true ou false
	 */
	public boolean isActif() {
		return actif;
	}

	/**
	 * Mutateur
	 * Affecte le boolan permettant de dterminer si l'item doit tre affich ou non (dans le cas du verrouillage des menus)
	 * @param true ou false
	 */
	public void setActif(boolean actif) {
		this.actif = actif;
	}

}
